/* 

   Bad Apple for your dock.

   - Rewritten from Jonas Aaberg's <cja@gmx.net> GAI example "Morning on earth".
   The example is included in gai-0.5.x (which can be obtained here: https://gai.sourceforge.net/)

   Requires GAI version 0.5.3 or later.

   Released under GNU GPL.
   
*/

#include "config.h"
#include <gai/gai.h>

#define HEIGHT 64
#define WIDTH 64
#define FRAMES 6572

static int frame_counter = 0;
static GdkPixbuf *img;
int n = 0;

void update()
{
	//stupid
	if(n == 0){
		if(frame_counter == FRAMES-1)
			frame_counter = 0;
		else 
			frame_counter++;
		gai_draw_bg(img, 0, frame_counter*HEIGHT, 
		WIDTH, HEIGHT, 0,0);
		gai_draw_update_bg();

	}
}

void ispaused()
{	
	if(n == 1)
		n = 0;
	else
		n = 1;
} 

void reset()
{
	frame_counter = 0;
	n = 0;
}

int main(int argc, char **argv)
{
    GaiFlagsType gf = GAI_FLAGS_NEVER_ROTATE;
    gai_init2(&applet_defines, &argc, &argv);
    img = gai_load_image("./images/wmbadapple.png");
    gai_background_set(WIDTH, HEIGHT, GAI_BACKGROUND_MAX_SIZE_NONE, TRUE);
    gai_flags_set(gf);
    gai_signal_on_update((GaiCallback0 *)update, 33.33, NULL);
    gai_signal_on_mouse_button_click((GaiCallback2 *)ispaused, GAI_MOUSE_BUTTON_1, NULL);
    gai_signal_on_mouse_button_click((GaiCallback2 *)reset, GAI_MOUSE_BUTTON_2, NULL);
    gai_start();
    return 0;
}
